#!/usr/bin/env python

from diffpy.pdfgetx import loadData
from pylab import *

r0, g0 = loadData('L_Menthol_nor-pdfgetx2.gr', usecols=(0, 1)).T
r1, g1 = loadData('L_Menthol_nor-pdfgetx3.gr').T
g1s = max(g0) / max(g1) * g1
gds = g0 - interp(r0, r1, g1s)
plot(r0, g0, label='PDFGetX2, Qmax=15/A')
plot(r1, g1s, label='PDFGetX3, Qmax=15/A, scaled')
plot(r0, gds - 10, label='difference curve')
title('L-Menthol')
xlabel('r (A)')
ylabel('G (A$^{-2}$)')
legend(prop=dict(size=11))
show()
