#!/usr/bin/env python

"""Plot nickel PDFs processed with PDFGetX2 and PDFGetX3 and their difference.
"""

from diffpy.pdfgetx import loadData
from pylab import *

r0, g0 = loadData('ni300mesh_300k_nor_1-5-pdfgetx2.gr',
        usecols=(0, 1), unpack=True)
r1, g1 = loadData('ni300mesh_300k_nor_1-5-pdfgetx3.gr', unpack=True)
g1s = max(g0) / max(g1) * g1
gds = g0 - interp(r0, r1, g1s)
plot(r0, g0, label='PDFGetX2, Qmax=27/A')
plot(r1, g1s, label='PDFGetX3, Qmax=26/A, scaled')
plot(r0, gds - 10, label='difference curve')
title('Ni')
xlabel('r (A)')
ylabel('G (A$^{-2}$)')
legend(prop=dict(size=11))
xlim(0, 30)
show()
